%mFastaExtractor_multiple_forGUI.m     %By Ali Mokdad - 2005/07/12
%This program first reads a complete alignment file, then lets the user chose the positions that he needs
%to extract from that complete alignment to make a smaller more relevent alignment for his purposes.

% IgnoreTopOrganisms = '0';
% 
% 
% prompt = {'DomainsToExtract domain (All, 0, 1, ...)',
%     'DomainsToExtract organism name',
%     'Input Nucleotides, comma separated',
%     'Ignore top organism? (1 for yes, 0 for no)'};
% title = 'Fasta Extractor';
% lines = 1;
% def = {DomainsToExtract,OrganismName,ILList,IgnoreTopOrganisms};%the default values set above
% answer = inputdlg(prompt,title,lines,def);
% assignin('base','DomainsToExtract',answer{1});
% assignin('base','OrganismName',answer{2});
% assignin('base','LocPosInput',answer{3});
% assignin('base','IgnoreTopOrganisms',answer{4});
% 
% LocPosInput = str2num(LocPosInput);
% IgnoreTopOrganisms = str2num(IgnoreTopOrganisms);
% OrganismName = {OrganismName};

for lpi=1:length(LocPosInput)
    index   = findstr(',',LocPosInput{lpi});
    index   = [index length(LocPosInput{lpi})+1];
    ind     = findstr('-',LocPosInput{lpi});
    %Test if numbers make sense or not:
    InputFormatError = 'The input numbers do not make sense, please follow this format: LocPosInput{lpi} = ''2-12,16,30-17,15-20'';';
    % InputFormatError1=InputFormatError;InputFormatError2=InputFormatError;InputFormatError3=InputFormatError;

    GoAhead = 1;
    if length(ind) ~= length(index)     ,   lpi,InputFormatError,' - , ', GoAhead=0; end
    if (ind(1)<2) || (ind(1)>index(1))  ,   lpi,InputFormatError,' - ', GoAhead=0; end
    for i=2:length(ind),
        if (ind(i)<index(i-1)) || (ind(i)>index(i))  ,   InputFormatError, GoAhead=0; end
    end

    if GoAhead==1;
        clear LocPos1; clear LocPos2; clear UniPos1; clear UniPos2;
        
        LocPos1(1) = str2num(LocPosInput{lpi}(1:ind(1)-1));
        LocPos2(1) = str2num(LocPosInput{lpi}(ind(1)+1:index(1)-1));
        for i=2:length(index)
            LocPos1(i) = str2num(LocPosInput{lpi}(index(i-1):ind(i)-1));
            LocPos2(i) = str2num(LocPosInput{lpi}(ind(i)+1:index(i)-1));
        end

        n = 1; %needed for mGetUnivFromAnyFasta
%         OrigDir = cd;
%         cd ..
        mGetUnivFromAnyFasta
%         cd(OrigDir)

        UniPos1 = Univ(LocPos1);
        UniPos2 = Univ(LocPos2);

        if ~strcmp(DomainNamesToExtract,'All')
            sequences = DomainLimits(DomainsToExtract)+1+IgnoreTopOrganisms : DomainLimits(DomainsToExtract+1);
        else
            sequences = DomainLimits(1)+1+IgnoreTopOrganisms : DomainLimits(end);
        end

        %FastaOutputFile = strcat(FastaPath,FastaFilename,'_extract_',DomainsToExtract,'_',RefOrganismName{1},'_',LocPosName{lpi},'.fasta');
        FastaOutputFile = strcat(FastaPath,FastaFilename,'_',LocPosName{lpi},'_',DomainNamesToExtract,'.fasta');
        FastafidOUT = fopen(FastaOutputFile,'w+');
        if FastafidOUT == -1      %Error check loop
            ErrorOUT = ['The file: ',FastaOutputFile,' could not be written to. It may be open. Please close it and try again'];
        else
            for j=sequences
                fprintf(FastafidOUT,'%s%s\n','>',FastaOrganismNames{j});
                for i=1:length(index)
                    if UniPos1(i)<UniPos2(i)
                        fprintf(FastafidOUT,'%s',Sequences(j,UniPos1(i):UniPos2(i)));
                    else
                        fprintf(FastafidOUT,'%s',Sequences(j,UniPos1(i):-1:UniPos2(i)));
                    end
                    if i~=length(index),
                        fprintf(FastafidOUT,'%s','....'); %this works well with the sequence parser
                    else fprintf(FastafidOUT,'\n');
                    end
                end
            end
        end
        if FastafidOUT ~= -1      %Error check loop
            fclose(FastafidOUT);
            %fprintf('\n%s\n%s\n','The requested part of your fasta file was saved under:',FastaOutputFile);
        end
        
        if ~isempty(BPlist)
            mBPlistExtractor %%%
            BPLOutputFile = strcat(FastaPath,PositionList,'_',LocPosName{lpi},'.xls');
            xlswrite(BPLOutputFile, BPsThatBelongHere);
        end

    end
end

fprintf('\n%s\n','Filename created:')
for lpi=1:length(LocPosInput)
    fprintf('%s%s%s%s%s%s\n',FastaFilename,'_',DomainNamesToExtract,'_',LocPosName{lpi},'.fasta');
end

fprintf('\n%s\n%s\n','The requested part(s) of your fasta file can be found in the folder:',FastaPath);